package cn.oringes.mc.panfarmers.item;

import cn.oringes.mc.panfarmers.PanFarmers;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.util.Identifier;

public class ModItems {
    public static final Item RICE_EAR = registerItems("rice_ear", new Item(new Item.Settings()));

    public static Item registerItems(String id, Item item){
        return Registry.register(Registries.ITEM, RegistryKey.of(Registries.ITEM.getKey(), new Identifier(PanFarmers.MOD_ID, id)), item);
    }

    public static Item registerItem(String id, Item item){
        return Registry.register(Registries.ITEM, new Identifier(PanFarmers.MOD_ID, id), item);
    }

    public static Item register(String id, Item item) {
        return register(new Identifier(id), item);
    }

    public static Item register(Identifier id, Item item) {
        return register(RegistryKey.of(Registries.ITEM.getKey(), id), item);
    }

    public static Item register(RegistryKey<Item> key, Item item) {
        if (item instanceof BlockItem) {
            ((BlockItem)item).appendBlocks(Item.BLOCK_ITEMS, item);
        }

        return (Item) Registry.register(Registries.ITEM, key, item);
    }

    public static void registerItems(){
        //
    }
}
