package cn.oringes.mc.panfarmers.item;

import cn.oringes.mc.panfarmers.PanFarmers;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;

public class ModItemGroups {
    public static final RegistryKey<ItemGroup> PanFarmers_Groups = register("panfarmers_groups");

    private static RegistryKey<ItemGroup> register(String id) {
        return RegistryKey.of(RegistryKeys.ITEM_GROUP, new Identifier(PanFarmers.MOD_ID, id));
    }

    public static void registerGroups() {
        Registry.register(
                Registries.ITEM_GROUP,
                PanFarmers_Groups,
                //ItemGroup.create(ItemGroup.Row.TOP, 7)
                ItemGroup.create(null, -1)
                        .displayName(Text.translatable("Pan Farmers"))
                        .icon(() -> new ItemStack(ModItems.RICE_EAR))
                        .entries((displayContext, entries) -> {
                            entries.add(ModItems.RICE_EAR);
                        }).build());

    }
}
